#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os, sys, site 
import re, urllib
import datetime, time

import glob
import shutil

from config import *

__all__ = [
                'PANEO_ROOT',
                'PANEO_SITE_DIR',
                'PANEO_SITE_DATA_DIR',
                'PANEO_FOLDER_PREFIX',

                'PANEO_DB',
                'SESSION_DB',
                'ARTICLES_DB',

                'TEMPLATE_DIR',
                'TEMPLATE_INC_DIR',
                'TEMPLATE_BACKUP_DIR',

                'RENDER_IMPORTS',

                #article
                'ARTICLES',
                'ARTICLES_TYPE',

                #config
                'HTML_CACHE',
                'IMG_CONV',
                'SCSS_CONV',
                'PAGE_TEMPLATE_SET',
                'AWS_SEARCH_INDEX',
                'AWS_SORT',
                'AWS_KEY',
                'SECRET_KEY',
                'ASSOCIATE_TAG',

                'none_to_blank',

                #PANEO SIZE
                'PANEO_WIDTH',
                'PANEO_HEIGHT',
                'TABLET_WIDTH',
                'SMART_PHONE_WIDTH',

]

RENDER_IMPORTS = [ 
'import web',
'from models import VIEWED',
'''from generator import (
        PANEO_ROOT,
        PANEO_SITE_DIR,
        PANEO_SITE_DATA_DIR,
        PAGE_TEMPLATE_SET,
        TEMPLATE_DIR,
        TEMPLATE_INC_DIR,
        ARTICLES,
        ARTICLES_TYPE,
        none_to_blank,

        PANEO_WIDTH,
        PANEO_HEIGHT,
        TABLET_WIDTH,
        SMART_PHONE_WIDTH,
)'''
]

def none_to_blank(value):
    if value is None:
        return ""
    else:
        return value 

#SITE GENTERATE
PANEO_ROOT = os.path.dirname(__file__)  #main.py directory
PANEO_FOLDER_PREFIX = "_paneo_data"

#PANEO PATH SETTING
PANEO_SITE_DATA_DIR =  os.path.join( PANEO_ROOT , '../' + PANEO_SITE_DIR + '/' ).replace('\\','/')

#CHECK SITE DATA FOLDER
if not os.path.exists( PANEO_SITE_DATA_DIR ):
    os.mkdir( PANEO_SITE_DATA_DIR )

#/////////////////////////////////////////////////////////////////////////////////////////////////////////
#SITE CONFIG
#/////////////////////////////////////////////////////////////////////////////////////////////////////////
def PaneoSiteDataFolderCheck( target ):
    check =  os.path.join( PANEO_ROOT , '../' + PANEO_SITE_DIR + ( '/%s/' % target ) ).replace('\\','/')
    if not os.path.exists( check ):
        os.mkdir( check )

PaneoSiteDataFolderCheck('_paneo_data')
sys.path.append(os.path.join( PANEO_ROOT , '../' + PANEO_SITE_DIR + ( '/%s/' % PANEO_FOLDER_PREFIX ) ).replace('\\','/') )

#from pprint import pprint as p
#p(sys.path)

#/////////////////////////////////////////////////////////////////////////////////////////////////////////
#ARTICLE CONFIG
#/////////////////////////////////////////////////////////////////////////////////////////////////////////
try:
    from config_article import *
except:
    src = PANEO_ROOT + ('/_paneo_files/__config_article.py')
    dst = PANEO_SITE_DATA_DIR + ('%s/config_article.py' % PANEO_FOLDER_PREFIX )
    shutil.copyfile(src, dst)
    from config_article import *

#/////////////////////////////////////////////////////////////////////////////////////////////////////////
#DB FILE
#/////////////////////////////////////////////////////////////////////////////////////////////////////////
PaneoSiteDataFolderCheck('%s/db' % PANEO_FOLDER_PREFIX)
PANEO_DB = os.path.join( PANEO_SITE_DATA_DIR , "%s/db/paneodb.sqlite3" % PANEO_FOLDER_PREFIX ).replace('\\','/')
SESSION_DB = os.path.join( PANEO_SITE_DATA_DIR , "%s/db/sessions.sqlite3" % PANEO_FOLDER_PREFIX ).replace('\\','/')
ARTICLES_DB = os.path.join( PANEO_SITE_DATA_DIR , "%s/db/articles.sqlite3" % PANEO_FOLDER_PREFIX ).replace('\\','/')

#/////////////////////////////////////////////////////////////////////////////////////////////////////////
#SITE FILE 
#/////////////////////////////////////////////////////////////////////////////////////////////////////////
def PaneoFileCopy( target , source ):
    files = glob.glob( PANEO_ROOT + '/_paneo_files/' + target + '/' + '*.*')
    for f in files:
        fname = os.path.split(f)[1]
        name, ext = os.path.splitext(fname)
        dst = PANEO_SITE_DATA_DIR + source + '/' + fname
        if not os.path.exists( dst ):
            shutil.copyfile( f , dst )
            
PaneoSiteDataFolderCheck('common')

PaneoSiteDataFolderCheck('common/css')
PaneoFileCopy('common/css','common/css')

PaneoSiteDataFolderCheck('common/css/article')

PaneoSiteDataFolderCheck('common/js')
PaneoFileCopy('common/js','common/js')

PaneoSiteDataFolderCheck('common/img')
PaneoFileCopy('common/img','common/img')

PaneoSiteDataFolderCheck('common/PIE')
PaneoFileCopy('common/PIE','common/PIE')

#/////////////////////////////////////////////////////////////////////////////////////////////////////////
#TEMPLATE FILE
#/////////////////////////////////////////////////////////////////////////////////////////////////////////
PaneoSiteDataFolderCheck('%s/templates/' % PANEO_FOLDER_PREFIX )
PaneoSiteDataFolderCheck('%s/templates/include/' % PANEO_FOLDER_PREFIX )
PaneoFileCopy('html/include','%s/templates/include' % PANEO_FOLDER_PREFIX )

PaneoSiteDataFolderCheck('%s/templates/_backup/' % PANEO_FOLDER_PREFIX )
PaneoSiteDataFolderCheck('%s/templates/page_templateset/' % PANEO_FOLDER_PREFIX )

PaneoSiteDataFolderCheck('%s/templates/page_templateset/default/' % PANEO_FOLDER_PREFIX )
PaneoFileCopy('html/default/','%s/templates/page_templateset/default/' % PANEO_FOLDER_PREFIX )

PaneoSiteDataFolderCheck('%s/templates/article_templateset/' % PANEO_FOLDER_PREFIX )
PaneoSiteDataFolderCheck('%s/templates/article_templateset/default/' % PANEO_FOLDER_PREFIX )
PaneoFileCopy('html/default/','%s/templates/article_templateset/default/' % PANEO_FOLDER_PREFIX )

TEMPLATE_DIR = os.path.join( PANEO_SITE_DATA_DIR , "%s/templates/" % PANEO_FOLDER_PREFIX ).replace('\\','/')
TEMPLATE_INC_DIR = os.path.join( PANEO_SITE_DATA_DIR , "%s/templates/include/" % PANEO_FOLDER_PREFIX ).replace('\\','/')
TEMPLATE_BACKUP_DIR = os.path.join( PANEO_SITE_DATA_DIR , "%s/templates/backup/" % PANEO_FOLDER_PREFIX ).replace('\\','/')

#INIT INDEX.html
dst = PANEO_SITE_DATA_DIR + '/index.html'
if not os.path.exists( dst ):
    src = PANEO_ROOT + '/_paneo_files/html/index.html'
    shutil.copyfile(src, dst)


#/////////////////////////////////////////////////////////////////////////////////////////////////////////
#ETC FILE 
#/////////////////////////////////////////////////////////////////////////////////////////////////////////
PaneoSiteDataFolderCheck('_tmp')
PaneoSiteDataFolderCheck('_tmp/cache')
PaneoSiteDataFolderCheck('_tmp/cache/img')
PaneoSiteDataFolderCheck('_tmp/cache/file')

#/////////////////////////////////////////////////////////////////////////////////////////////////////////
#AMAZON PARAM
#/////////////////////////////////////////////////////////////////////////////////////////////////////////
AWS_SEARCH_INDEX = {
  "All":               u"全て",
  "Apparel":           u"アパレル&ファッション雑貨",
  "Baby Product":      u"ベビー&マタニティ",
  "Book":              u"本・漫画・雑誌",
  "CE":                u"家電&カメラ",
  "DVD":               u"DVD",
  "Grocery":           u"食品&飲料",
  "Health and Beauty": u"ヘルス&ビューティー",
  "Kitchen":           u"ホーム&キッチン",
  "Music":             u"ミュージック",
  "Office Product":    u"文房具・オフィス用品",
  "Shoes":             u"シューズ",
  "Software":          u"PCソフト",
  "Sports":            u"スポーツ&アウトドア",
  "Toys":               u"おもちゃ",
  "VHS":               u"ビデオ",
  "Video Games":       u"TVゲーム",
  "Watch":             u"時計"
}

AWS_SORT = {
        "":u"-指定なし",
        "salesrank":u"総合評価",
        "price":u"価格が安い順",
        "-price":u"価格が高い順",
        "reviewrank":u"レビュー",
        "releasedate":u"発売日順",
}        


